unit scan_disk;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TScandisk = class(TForm)
    cmd_choix_fichier: TButton;
    Label_legende: TLabel;
    Label_legende_libre: TLabel;
    Label_legende_systeme: TLabel;
    Label_legende_utilise: TLabel;
    Label_legende_mauvais: TLabel;
    Legende_systeme: TShape;
    Legende_mauvais: TShape;
    Legende_utilise: TShape;
    Legende_reserve: TShape;
    Label_legende_reserve: TLabel;
    Legende_libre: TShape;
    Nom_image_disque: TLabel;
    Panel1: TPanel;
    nb_clusters_syst: TLabel;
    nb_clusters_mauvais: TLabel;
    nb_clusters_utilises: TLabel;
    nb_clusters_reserves: TLabel;
    nb_clusters_libres: TLabel;
    ScrollBox1: TScrollBox;
    Fond: TPaintBox;
    procedure cmd_choix_fichierClick(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FondPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Scandisk: TScandisk;
  grille:array of tcolor;

implementation

uses MAIN,tout,traduction;

{$R *.dfm}

//Chix du fichier et scan des clusters
procedure TScandisk.cmd_choix_fichierClick(Sender: TObject);
var
    nom_fichier:string;
    image_disque:imagedisk;
    nb_clusters_autres:integer;
    nb_clusters_systeme:integer;
    nb_clusters_total:integer;
    compteur:integer;
    info_cluster:integer;
    index:integer;

begin
    MSA_Converter.selecfichier.title:=textes_general[75];
    MSA_Converter.selecfichier.filter:=textes_general[70]+'|'+textes_general[71]+'|'+textes_general[72]+'|'+textes_general[73]+'|'+textes_general[74]+'|'+textes_general[80];
    MSA_Converter.selecfichier.fileName:='';
    MSA_Converter.selecfichier.options:=[ofFileMustExist,ofPathMustExist,ofHideReadOnly];
    MSA_Converter.selecfichier.InitialDir:=rep_utilisateur;

    if MSA_Converter.selecfichier.Execute=true then
    begin
        nom_fichier:=MSA_Converter.selecfichier.filename;
        rep_utilisateur:=extraire_repertoire(nom_fichier);
        image_disque.nomfichier:=nom_fichier;
        nom_image_disque.Caption:=extraire_nom_fichier(nom_fichier);

        try
            charge_image_disque(@image_disque);
            lire_infos_image_disque(@image_disque,true);
            if image_disque.fichier_ok=true then
            begin
                if image_disque.sorte<>'st' then
                begin
                    if image_disque.sorte='msa' then conversion_msa_vers_st(@image_disque,@fichier_temp)
                    else if image_disque.sorte='dim' then conversion_dim_vers_st(@image_disque,@fichier_temp)
                    else if image_disque.sorte='stt' then conversion_stt_vers_st(@image_disque,@fichier_temp);
                    setlength(image_disque.donnees,length(fichier_temp.donnees));
                    copymemory(@image_disque.donnees[0],@fichier_temp.donnees[0],length(fichier_temp.donnees));
                    image_disque.nomfichier:='msatemp.st';
                    lire_infos_image_disque(@image_disque,true);
                    setlength(fichier_temp.donnees,0);
                end;

                //Lit l'tat de tous les clusters
                nb_clusters_systeme:=comptage_clusters(5,@image_disque);
                nb_clusters_total:=comptage_clusters(6,@image_disque);
                nb_clusters_autres:=nb_clusters_total-nb_clusters_systeme+1;
                setlength(grille,nb_clusters_total);
                index:=0;

                //Rgle la hauteur du fond pour l'affichage
                //Lignes de 31 cases et de 9pts de haut
                fond.Height:=round((nb_clusters_total*9)/31)+9;

                //Clusters systme
                for compteur:=1 to nb_clusters_systeme do
                begin
                    grille[index]:=clyellow;
                    inc(index);
                end;

                //Autres clusters
                for compteur:=2 to nb_clusters_autres do
                begin
                    info_cluster:=lire_etat_cluster(compteur,@image_disque);
                    if info_cluster=$000 then grille[index]:=clwhite;
                    if (info_cluster>=$001) and (info_cluster<=$fef) then grille[index]:=cllime;
                    if (info_cluster>=$ff8) and (info_cluster<=$fff) then grille[index]:=cllime;
                    if (info_cluster>=$ff0) and (info_cluster<=$ff6) then grille[index]:=clblue;
                    if info_cluster=$ff7 then grille[index]:=clred;
                    inc(index);
                end;

                //Dessine la grille
                fond.Repaint;

                //Remplissage des nombres de clusters de chaque type
                nb_clusters_libres.Caption:=inttostr(comptage_clusters(1,@image_disque));
                nb_clusters_utilises.Caption:=inttostr(comptage_clusters(2,@image_disque));
                nb_clusters_reserves.Caption:=inttostr(comptage_clusters(3,@image_disque));
                nb_clusters_mauvais.Caption:=inttostr(comptage_clusters(4,@image_disque));
                nb_clusters_syst.Caption:=inttostr(comptage_clusters(5,@image_disque));
            end;
        except
            MessageDlg(textes_disquette[7]+nom_fichier, mtInformation, [mbOk], 0);
        end;
    end;
    setlength(image_disque.donnees,0);
end;

//Fermeture de la fentre
procedure TScandisk.FormDeactivate(Sender: TObject);
begin
    setlength(grille,0);
    close;
end;

//Dessin de la grille des clusters
procedure TScandisk.FondPaint(Sender: TObject);
var
    index:integer;
    max:integer;
    x:integer;
    y:integer;

begin
    max:=length(grille)-1;
    if max<>0 then
    begin
        x:=0;
        y:=2;
        for index:=0 to max do
        begin
            fond.Canvas.Brush.Color:=grille[index];
            fond.Canvas.Rectangle(x,y,x+7,y+7);
            inc(x,9);
            if x>fond.Width-7 then
            begin
                inc(y,9);
                x:=0;
            end;
        end;
    end;
end;

//Initialisation
procedure TScandisk.FormShow(Sender: TObject);
begin
    traduction_textes_scandisk;
    nb_clusters_libres.Caption:='0';
    nb_clusters_utilises.Caption:='0';
    nb_clusters_reserves.Caption:='0';
    nb_clusters_mauvais.Caption:='0';
    nb_clusters_syst.Caption:='0';
    nom_image_disque.Caption:='';
end;

end.
